<?php
/*
	Title:			explorer_securl.php
	Description:	Checks if the typed text is a valid url, if not, it cleans it
	Project:		PH Pexplorer	
	Version:		0.22
	Created:		Sun 13-09-2006
	Author:			bluevirus-design
	Website:		www.bluevirus.ch.vu
	
	Freeware under Terms of GNU
*/
function securl($URL)
{
	//	Wir wollen kein / am Ende haben.
	$URL.="/";
	//	Ungewollte Zeichen entfernen
	$URL=preg_replace("@([\"\<\>\*\?\|]){1,}@si","",$URL);
	//wobei nur an zweiter strpos ein : stehen darf
	$URL=substr($URL,0,2).preg_replace("@:@","",substr($URL,2) );
	
	$tmp="";
	$max=1000;	// So wird es sicher keine Endlosschlaufe
	do
	{
		$max--;
		//	Ersetze alle \ , ..\ , ../ , ./ , // durch /
		$tmp=$URL;
		$URL=preg_replace("@(\/\/|\\\\)@si","/",$URL);
		$URL=preg_replace("@(/|^|/(\.*))(\.\./|\./|\/\/)@si","\\1/",$URL);
	}
	while($URL!=$tmp and $max>0);
	
	//	Falls $max == 0, wurde versucht zu Cheaten (beim betrachten einer Pfadlnge von Max 255 Zeichen und WIN
	//	macht das durchaus Sinn)
	if($max==0)
		$URL=t_c_folder;
	
	// Wir wollen t_c_folder immer am Anfang einer URL haben (i.e: t_c_folder oder t_c_folder/irgendwas...)
	$tmp=strpos($URL,t_c_folder."/");
	if( ($tmp===false or $tmp!=0) /*and ( strlen($URL)>strlen(t_c_folder) )*/ )
		$URL=t_c_folder."/".$URL;
	
	
	
	//	/ am Ende entfernen
	$URL=substr($URL,0,strlen($URL)-1);
	
	return $URL;
}
?>